# Generated by `rjournal_pdf_article()` using `knitr::purl()`: do not edit by hand
# Please edit GSSTDA.Rmd to modify this file

## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = FALSE, warning = FALSE, message = FALSE)
library(GSSTDA)
library(kableExtra)
library(dplyr)
library(tidyr)


## ----fun.tab------------------------------------------------------------------
input <- 
  c(
    "`dsga`", "For `dsga object`. It allows the calculation of the `disease component` of \n a expression matrix which consists of, through linear models, eliminating the part of the data that is considered normal or healthy and keeping only the \n component that is due to the  disease. It is intended to precede other techniques like  classification or clustering. \n For more information see @Nicolau2007.",
    
    "`results_dsga`", "For `dsga object`. It calculates the 100 genes with the highest variability in \n the matrix disease component between samples and use them to draw the heat map.",
    
    "`gene_selection`", "For `gene_selection object`. It fittings a Cox proportional hazard model to \n each gene, then it makes a selection of genes according to both: their variability within the database and their relationship with survival. Subsequently, with the genes selected, it calculates the values of the filtering functions for each patient. \n The filter function allows to summarise each vector of each individual in a single data. This function takes into account the \n survival associated with each gene. In particular, the implemented filter function performs the vector magnitude \n in the Lp-norm (as well as k powers of this magnitude) of the vector resulting of weighting each element of \n the column vector by the Z score obtained in the cox proportional hazard model.",
    
    "`mapper`", "For `mapper object`. It condenses the information of high-dimensional data sets into a combinatory graph or \n simplicial complex that is referred to as the skeleton of the data set. This implementation is the mapper of \n one dimension, i.e. using only one filter function value.",
    
    "`plot_mapper`", "For `mapper object`. It produces an interactive network plot using visNetwork \n function from the mapper results.",
    
    "`gsstda`", "For `gsstda object`. It integrate the three parts of the process: the preprocessing of the data [dsga process], \n the gene selection and the filter function [gene selection process], and the mapper algorithm [mapper process]."
  )

fun.tab <- data.frame(matrix(input, ncol = 2, byrow = T), stringsAsFactors = FALSE)
names(fun.tab) = c("Function", "Description")



## ----fun-tabh, eval = knitr::is_html_output(), layout = "l-body-outset"-------
# fun.tab %>%
#   knitr::kable(format = "html", caption = "GSSTDA package functions", booktabs=TRUE) %>%
#   kable_styling(latex_options="scale_down")


## ----fun-tabl, eval = knitr::is_latex_output(), layout = "l-body-outset"------
fun.tab %>%
  knitr::kable(format = "latex", caption = "GSSTDA package functions", booktabs=TRUE, align = 'l') %>% 
      column_spec(1,width = "1in") %>%
      column_spec(2,width = "4in")


## ----load_data, echo = TRUE, eval = TRUE--------------------------------------
# We load the data
data("full_data")
data("survival_time")
data("survival_event")
data("case_tag")


## ----descrip_full_data--------------------------------------------------------
summary_descrip_full_data <- full_data[1:10, 1:4]


## ----descr-full_data-html, eval = knitr::is_html_output(), layout = "l-body-outset"----
# knitr::kable(summary_descrip_full_data, format = "html", caption = "Descriptive statistics of the four first variables included in the `full_data`",digits = 3)


## ----descr-full_data-lat, eval = knitr::is_latex_output()---------------------
summary_descrip_full_data %>%
  knitr::kable(format = "latex", booktabs=TRUE, align = 'l', 
               digits = 3)


## ----descrip_survival_time----------------------------------------------------
summary_descrip_survival_time <- round(survival_time[15:25], digits = 3)
summary_descrip_survival_event <- survival_event[15:25]
summary_descrip_case_tag <- case_tag[15:25]

input <- c("`survival_time`", paste(summary_descrip_survival_time, collapse=" "),
           "`survival_event`", paste(summary_descrip_survival_event, collapse=" "),
           "`case_tag`", paste(summary_descrip_case_tag, collapse=" "))

fun.summ <- data.frame(matrix(input, ncol = 2, byrow = T), stringsAsFactors = FALSE)
names(fun.summ) = c("Vectors", "Extract of the values")



## ----fun-summh, eval = knitr::is_html_output(), layout = "l-body-outset"------
# fun.summ %>%
#   knitr::kable(format = "html", caption = "Descriptive statistics of ten variables included in the `survival_time`, `survival_event` and `case_tag`", booktabs=TRUE) %>%
#   kable_styling(latex_options="scale_down")


## ----fun-summl, eval = knitr::is_latex_output(), layout = "l-body-outset"-----
fun.summ %>%
  knitr::kable(format = "latex", booktabs=TRUE, align = 'l') %>% 
      column_spec(1,width = "1in") %>%
      column_spec(2,width = "4in")


## ----dsga_obj, echo = TRUE, eval = FALSE--------------------------------------
# dsga_object <- dsga(full_data, survival_time, survival_event, case_tag, gamma)


## ----dsga_obj_info, echo = TRUE, results = F, fig.show='hide'-----------------
dsga_object <- dsga(full_data = full_data,
                    survival_time = survival_time,
                    survival_event = survival_event,
                    case_tag = case_tag)

dsga_information <- results_dsga(
                    matrix_disease_component = dsga_object[["matrix_disease_component"]],
                    case_tag = case_tag)


## ----print_dsga_info, echo = TRUE, eval = TRUE, fig.show='hide'---------------
print(dsga_information)


## ----fig1, out.width = "100%", out.height = "30%", fig.cap = "Heatmap of the disease component matrix (result of the `dsga` function) after selecting the 100 genes with the highest variability between samples. Each column represents a patient sample and each row represents a gene. The color scale reflects the values of the disease component, with warmer colors indicating higher expression values than in healthy tissue and cooler colors indicating lower expression. Key: `NT` stands for `Non-Tumor` – representing normal breast biopsy samples; `T` stands for `Tumor` – representing breast cancer biopsy samples. In addition, the result of the hierarchical clustering of the samples using the euclidean distance and the complete method is included. This visualization aids in distinguishing between the disease component profiles of tumor and non-tumor samples, highlighting the difference between the two types after preprocessing with DSGA."----
knitr::include_graphics("Figures/print_DSGA_information.png")


## ----gene_obj, echo = TRUE, eval = FALSE--------------------------------------
# gene_selection_object <- gene_selection(data, gen_select_type, percent_gen_select)


## ----dsga_gene_selection1, echo = T, results = F------------------------------
dsga_object <- dsga(full_data = full_data,
                    survival_time = survival_time,
                    survival_event = survival_event, 
                    case_tag = case_tag)
gene_selection_object <- gene_selection(data =  dsga_object,
                                      gen_select_type = "Top_Bot", 
                                      percent_gen_select = 10)


## ----dsga_gene_selection2, echo = T, results = F------------------------------
# Create data object
data_object <- list(full_data = full_data,
                    survival_time = survival_time,
                    survival_event = survival_event,
                    case_tag = case_tag)
class(data_object) <- "data_object"

#Select gene from data object
gene_selection_object <- gene_selection(data = data_object, 
                                      gen_select_type = "Top_Bot",
                                      percent_gen_select = 10)


## ----mapper_obj, echo = TRUE, eval = FALSE------------------------------------
# mapper_object <- mapper(data,
#                         filter_values,
#                         num_intervals,
#                         percent_overlap,
#                         distance_type,
#                         clustering_type,
#                         num_bins_when_clustering,
#                         linkage_type,
#                         optimal_clustering_mode,
#                         silhouette_threshold)


## ----mapper_obj_exe, eval = TRUE, results=F-----------------------------------
mapper_object <- mapper(data = gene_selection_object[["genes_disease_component"]],
                        filter_values = gene_selection_object[["filter_values"]],
                        num_intervals = 10,
                        percent_overlap = 40,
                        distance_type = "correlation",
                        clustering_type = "hierarchical",
                        linkage_type = "single")


## ----print_mapper, echo = TRUE, eval = TRUE-----------------------------------
print(mapper_object)


## ----fig2, fig.label="fig:fig2", out.width = "65%", out.height = "40%", fig.cap = "Mapper result graph. Mapper visualization depicting clusters of samples based on gene expression profiles along the value of the filter function, with nodes representing clusters and edges indicating overlap, facilitating the identification of nodes of different gene expression patterns and survival. The intensity of the color within each node reflects the average level of filter function within the cluster, aiding in the characterization of biological significance. Low filter function values, represented in blue, are associated with better survival. High values, in red, are associated with worse survival. Additionally, annotation allows for the identification of a cluster of interest, assisting in the extraction of insight into potential biomarkers or gene expression patterns associated with specific sample groups. The default option used in this case resizes the node sizes as $No. samples^{1/2}$."----
knitr::include_graphics("Figures/plot_mapper_object.png")


## ----plot_mapper, echo = TRUE, eval = F, results=F----------------------------
# plot_mapper(mapper_object, trans_node_size = TRUE, exp_to_res = 1/1.5)


## ----fig3, fig.label="fig:fig3", out.width = "65%", out.height = "30%", fig.cap = "Mapper result graph after varying the parameter $exp\\_to\\_res$ to $1/1.5$ ($No. samples^{1/1.5}$). This way the resizing of the node size is smoother."----
knitr::include_graphics("Figures/plot_mapper_object_1_5.png")


## ----gsstda_obj, echo = TRUE, eval = FALSE------------------------------------
# gsstda_object <- gsstda(full_data, survival_time, survival_event, case_tag,
#                         gamma, gen_select_type, percent_gen_select,
#                         num_intervals, percent_overlap, distance_type,
#                         clustering_type, num_bins_when_clustering,
#                         linkage_type, optimal_clustering_mode,
#                         silhouette_threshold)


## ----gsstda_obj_exe, echo = T, eval = TRUE, results = F-----------------------
gsstda_object <- gsstda(full_data = full_data,
                        survival_time = survival_time, 
                        survival_event = survival_event,
                        case_tag = case_tag, 
                        gen_select_type = "Top_Bot", 
                        percent_gen_select = 10, 
                        num_intervals = 10,
                        percent_overlap = 40, 
                        distance_type = "correlation", 
                        clustering_type = "hierarchical", 
                        linkage_type = "single")

