options(prompt = "R> ", continue = "+  ", width = 70, useFancyQuotes = FALSE)

if(!"MGLM" %in% rownames(installed.packages()))
  install.packages("MGLM", repos="http://cran.rstudio.com/")
if(!"ggplot2" %in% rownames(installed.packages()))
  install.packages("ggplot2", repos="http://cran.rstudio.com/")
if(!"reshape2" %in% rownames(installed.packages()))
  install.packages("reshape2", repos="http://cran.rstudio.com/")
if(!"plyr" %in% rownames(installed.packages()))
  install.packages("plyr", repos="http://cran.rstudio.com/")
require("ggplot2")
require("reshape2")
require("plyr")
require("MGLM")
data("rnaseq")
data <- rnaseq[, 1:6]
head(rnaseq, n = 3)
dim(rnaseq)
system.time (
  dmFit <- MGLMfit(data, dist = "DM")
)
print(dmFit)
system.time(
  gdmFit <- MGLMfit(data, dist = "GDM")
)
print(gdmFit)
LRT <- -2 * (dmFit$logL - gdmFit$logL)
pchisq(LRT, ncol(data) - 2, lower.tail = FALSE)
system.time(
  negmnFit <- MGLMfit(data, dist = "NegMN")
)
print(negmnFit)
system.time(
  mnreg <- MGLMreg(formula = cbind(X1, X2, X3, X4, X5, X6) ~ log(totalReads) + 
                     treatment + age + gender, data = rnaseq, dist = "MN")
)
print(mnreg)
system.time(
  dmreg <- MGLMreg(formula = cbind(X1, X2, X3, X4, X5, X6) ~ log(totalReads) + 
                     treatment + age + gender, data = rnaseq, dist = "DM")
)
print(dmreg)
system.time(
  gdmreg <- MGLMreg(formula = cbind(X1, X2, X3, X4, X5, X6) ~ log(totalReads) + 
                      treatment + age + gender, data = rnaseq, dist = "GDM")
)
print(gdmreg)
system.time(
  negmnreg2 <- MGLMreg(formula = cbind(X1, X2, X3, X4, X5, X6) ~ 
                         log(totalReads) + treatment + age + gender,  
                       data = rnaseq, dist = "NegMN", regBeta = FALSE)
)
print(negmnreg2)
system.time(
    negmnreg <- MGLMreg(formula = cbind(X1, X2, X3, X4, X5, X6) ~ 
                          log(totalReads) + treatment + age + gender,
                        data = rnaseq, dist = "NegMN", regBeta = TRUE)
)
print(negmnreg)
dist <- "DM"
n <- 100
p <- 10
d <- 5
set.seed(118)
m <- rbinom(n, 200, 0.8)
X <- matrix(rnorm(n * p), n, p)
alpha <- matrix(0, p, d)
alpha[c(1, 3, 5), ] <- 1
Alpha <- exp(X %*% alpha)
Y <- rdirm(size = m, alpha = Alpha)
pen <- "group"
ngridpt <- 30
fit <- MGLMsparsereg(formula = Y ~ 0 + X, dist = dist, 
                     lambda = Inf, penalty = pen)
maxlambda <- fit$maxlambda
lambdas <- exp(seq(from = log(maxlambda), to = log(maxlambda / nrow(Y)), 
                   length.out = ngridpt))
BICs <- rep(0, ngridpt)
AICs <- rep(0, ngridpt)
LogLs <- rep(0, ngridpt)
Dofs <- rep(0, ngridpt)
ptm <- proc.time()
for (j in 1:ngridpt) {
  if (j == 1) {
    B0 <- matrix(0, p, ncol(fit$coefficients)) 
  }
  else B0 <- B_hat
  select.fit <- MGLMsparsereg(formula = Y ~ 0 + X, dist = dist,
                              lambda = lambdas[j], penalty = pen, init = B0)
  B_hat <- select.fit$coefficients
  BICs[j] <- select.fit$BIC
  LogLs[j] <- select.fit$logL
  AICs[j] <- select.fit$AIC
  Dofs[j] <- select.fit$Dof
}
proc.time() - ptm
pen <- "group"
ngridpt <- 30
fit <- MGLMsparsereg(formula = Y ~ 0 + X, dist = dist, 
                     lambda = Inf, penalty = pen)
maxlambda <- fit$maxlambda
lambdas <- exp(seq(from = log(maxlambda), to = log(maxlambda / nrow(Y)), 
               length.out = ngridpt))
chosen.lambda <- lambdas[which.min(BICs)]
select <- MGLMsparsereg(formula = Y ~ 0 + X, dist = dist, 
                        lambda = chosen.lambda, penalty = pen)
selectTune <- MGLMtune(Y ~ 0 + X, dist = dist, penalty = pen, ngridpt = 30,
                       display = FALSE)
path <- data.frame(BIC = BICs, Lambda = lambdas)
print(
  ggplot(path, aes(x = log(Lambda), y = BIC)) + geom_point() + geom_line() + 
    theme_bw() + xlab(expression(paste("log(", lambda, ")", sep = ""))) +
    geom_point(aes(x = log(Lambda[which.min(BIC)]), y = min(BIC)), color = "red")
)
Beta <- abs(select$coefficients)
betaDf <- as.data.frame(Beta)
names(betaDf) <- paste("B", c(1:ncol(Beta)), sep = "")
betaDf$i <- factor(1:nrow(Beta), levels = as.character(c(nrow(Beta):1)))
beta.m <- melt(betaDf, "i")

print(
  ggplot(beta.m, aes(x = variable, y = i)) + 
    geom_tile(aes(fill = value), colour = "white") + 
    scale_fill_gradient(low = "white", high = "steelblue") + theme_bw() +
    xlab("category") + ylab("variable") +
    theme(legend.position = "none", axis.ticks = element_blank())
)
system.time (
  select <- MGLMtune(Y ~ 0 + X, dist = "DM", penalty = "nuclear", 
                     ngridpt = 30, display = FALSE))
Beta <- abs(select$select$coefficients)
betaDf <- as.data.frame(Beta)
names(betaDf) <- paste("B", c(1:ncol(Beta)), sep = "")
betaDf$i <- factor(1:nrow(Beta), levels = as.character(c(nrow(Beta):1)))
beta.m <- melt(betaDf, "i")
ggplot(select$path, aes(x=log(Lambda),y=BIC)) + 
  geom_point() + geom_line() + 
  geom_point(aes(x=log(Lambda[which.min(BIC)]), y = min(BIC)), color = "red") +
  theme_bw() + xlab(expression(log(lambda)))
print(
  ggplot(beta.m, aes(x = variable, y = i)) + 
    geom_tile(aes(fill = value),colour = "white") + 
    scale_fill_gradient(low = "white", high = "steelblue") + theme_bw() +
    xlab("category") + ylab("variable") +
    theme(legend.position = "none",axis.ticks = element_blank())
)
system.time (
  select <- MGLMtune(Y ~ 0 + X, dist = "DM", penalty = "sweep", ngridpt = 30, 
                     display = FALSE))
Beta <- abs(select$select$coefficients)
betaDf <- as.data.frame(Beta)
names(betaDf) <- paste("B", c(1:ncol(Beta)), sep = "")
betaDf$i <- factor(1:nrow(Beta), levels = as.character(c(nrow(Beta):1)))
beta.m <- melt(betaDf, "i")
print(
  ggplot(select$path, aes(x = log(Lambda), y = BIC)) + 
    geom_point() + geom_line() +
    geom_point(aes(x = log(Lambda[which.min(BIC)]), y = min(BIC)), 
               color = "red") +
    theme_bw() + xlab(expression(log(lambda)))
)
print(
  ggplot(beta.m, aes(x = variable, y = i))+ 
    geom_tile(aes(fill = value), colour = "white") + 
    scale_fill_gradient(low = "white", high = "steelblue") + theme_bw() +
    xlab("category") + ylab("variable") +
    theme(legend.position = "none", axis.ticks = element_blank())
)
